﻿B4A=true
Group=Default Group
ModulesStructureVersion=1
Type=Class
Version=10.7
@EndOfDesignText@
#Event: Connected (Success As Boolean)
#Event: StateChanged (State As String)
Sub Class_Globals
	Private Admin As BluetoothAdmin
	Public Astreams As AsyncStreams
	Private Serial As Serial
	Private PH As Phone
	Private mParent As Object
	Private mEventName As String
	Private lblStatus As Label
	Private ProgressBar1 As ProgressBar
	Private GenericDeviceName, DeviceName As String
	Public BluetoothState, ConnectionState, DeviceFound As Boolean
	Private DeviceName, DeviceMacAdress As String
	Public CharSet = "UTF-8" As String
	Private sb As StringBuilder
	Public State As String
End Sub


Public Sub Initialize(Parent As Object, EventName As String, StatusLabel As Label, Pgb As ProgressBar)
	mParent = Parent
	mEventName = EventName
	lblStatus = StatusLabel
	Admin.Initialize("Admin")
	Serial.Initialize("Serial")
	ProgressBar1 = Pgb
	sb.Initialize
	
	If Admin.IsEnabled = False Then
		If Admin.Enable = False Then
			ToastMessageShow("Bluetooth module not available", True)
		Else
			ToastMessageShow("Bluetooth module available...", False)
		End If
	Else
		BluetoothState = True
	End If
End Sub

Public Sub Connect(Name As String)
	GenericDeviceName = Name
	Dim success As Boolean = Admin.StartDiscovery
	If success = False Then
		lblStatus.Text = "research process error"
	Else
		lblStatus.Text = "device search in progress"
		ProgressBar1.Visible = True
	End If
End Sub

Public Sub Disconnect
	If Astreams.IsInitialized Then Astreams.Close
	If Serial.IsInitialized Then Serial.Disconnect
End Sub

Private Sub Admin_DeviceFound (Name As String, MacAddress As String)
	Log(Name & ":" & MacAddress)
	If Name.Contains(GenericDeviceName) Then
		Log(GenericDeviceName & " found")
		DeviceName = Name
		DeviceMacAdress = MacAddress
		If PH.SdkVersion <= 24 Then
			Admin.CancelDiscovery
			lblStatus.Text = GenericDeviceName & " found"
		Else
			lblStatus.Text = GenericDeviceName & " found, please wait."
		End If
	End If
End Sub

Private Sub Admin_DiscoveryFinished
	If DeviceName = "" Then
		lblStatus.Text = "Module " & GenericDeviceName & " not detected"
		Msgbox2Async("The HC-05 Bluetooth Module does not seem to be powered, turn on the vehicle, the module's red mini-LED should flash quickly then press the Connect button again","check the module power supply", "OK", "", "", Null, True)
	Wait For Msgbox_Result (Result As Int)
		Else
		lblStatus.Text = "Connect to " & GenericDeviceName
		Serial.Connect(DeviceMacAdress)
	End If
End Sub

Private Sub Admin_StateChanged (NewState As Int, OldState As Int)
	Log("Status change: " & NewState)
	lblStatus.Text = "Actual status: " & NewState
	BluetoothState = NewState = Admin.STATE_ON
End Sub

Sub Serial_Connected (Success As Boolean)
	Private msg As String
	If Success = True Then
		If Astreams.IsInitialized Then Astreams.Close
		Astreams.Initialize(Serial.InputStream, Serial.OutputStream, "Astreams")
		msg = "HC05 Bluetooth Module Connected"
		ProgressBar1.Visible = False
		
	Else
		Log(LastException.Message)
		msg = LastException.Message
	End If
	lblStatus.Text = msg
	CallSubDelayed2(mParent, mEventName & "_Connected", Success)
End Sub

Public Sub SendBytes(Buffer() As Byte)
	Astreams.Write(Buffer)
End Sub

Public Sub SendText(Text As String)
	Astreams.Write(Text.GetBytes(CharSet))
End Sub

Public Sub Ast_NewText(Text As String)
	CallSubDelayed2(mParent, mEventName & "_NewText", Text)
	Log(Text)
End Sub

Public Sub WriteText(Text As String)
	Astreams.Write(Text.GetBytes(CharSet))
End Sub

Public Sub WriteBytes(Buffer() As Byte)
	Astreams.Write(Buffer)
End Sub

Private Sub Astreams_NewData (Buffer() As Byte)
	Dim newDataStart As Int = sb.Length
	sb.Append(BytesToString(Buffer, 0, Buffer.Length, CharSet))
	Dim s As String = sb.ToString
	Dim start As Int = 0
	For i = newDataStart To s.Length - 1
		Dim c As Char = s.CharAt(i)
		If i = 0 And c = Chr(10) Then '\n...
			start = 1 
			Continue
		End If
		If c = Chr(10) Then 
			CallSubDelayed2(mParent, mEventName & "_NewText", s.SubString2(start, i))
			start = i + 1
		Else If c = Chr(13) Then 
			CallSubDelayed2(mParent, mEventName & "_NewText", s.SubString2(start, i))
			If i < s.Length - 1 And s.CharAt(i + 1) = Chr(10) Then 
				i = i + 1
			End If
			start = i + 1
		End If
	Next
	If start > 0 Then sb.Remove(0, start)
End Sub

Private Sub Astreams_Terminated
	CallSubDelayed(mParent, mEventName & "_Terminated")
End Sub

Private Sub Astreams_Error
	Log("error: " & LastException)
	Astreams.Close
	CallSubDelayed(mParent, mEventName & "_Terminated")
End Sub

Public Sub Close
	Astreams.Close
End Sub
